from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class Aggravater(Player):
    """
    Grudger, except that it defects on the first 3 turns

    Names

    - Aggravater: Original name by Thomas Campbell
    """

    name = "Aggravater"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if len(opponent.history) < 3:
            return D
        elif opponent.defections:
            return D
        return C